package gov.va.med.mhv.login.hook;

import gov.va.med.mhv.usermgmt.service.UserMgmtService;

import java.io.IOException;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;


public class DsLogonUtils {
	
	@Resource(name = "userMgmtServiceProxy")
	protected UserMgmtService userMgmtServiceProxy;
	
	private static final Log logger = LogFactoryUtil.getLog(DsLogonUtils.class);
	public static final String CSID_PARAM = "va_eauth_csid";
	
	public boolean process(HttpServletRequest request, HttpServletResponse response) throws ActionException {
		boolean sso = false;
		System.out.println("******* DsLogonAction process");
		try {
			System.out.println("******* DsLogonAction process");
			String dsLogonValue = (String) request.getSession().getAttribute("useExistingSSO");
			//String dsLogonValue = retrieveVAFFIProperty(request, CSID_PARAM, true);
			System.out.println("******* DsLogonAction process dsLogonValue: " + dsLogonValue);
			if(dsLogonValue != null) {
				if(!dsLogonValue.isEmpty()) {
					sso = true;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ActionException(e);
		}		
		return sso;
	}

	public String retrieveVAFFIProperty(HttpServletRequest req, String attribute) {
		return retrieveVAFFIProperty(req, attribute, false);
	}

	public String retrieveVAFFIProperty(HttpServletRequest request, String attribute, boolean forced) {
		String trait = null;

		if (forced) {
			trait = request.getParameter(attribute);
			request.getSession().setAttribute(attribute, trait);
		} else {
			trait = (String) request.getSession().getAttribute(attribute);
			if (trait == null) {
				trait = request.getParameter(attribute);
				request.getSession().setAttribute(attribute, trait);
			}
		}

		if (logger.isInfoEnabled()) {
			logger.info("VAFFIProperty:" + attribute + "=" + trait);
		}

		return trait;
	}
}